program Listing3;

uses
  RTTI, System.SysUtils, TypInfo, System.Classes;

type
  TWirtualnyInterfejsRaportujący = class(TVirtualInterface)
    constructor Create(PIID: PTypeInfo);
    procedure WywołajMetodę(Metoda: TRttiMethod; const Argumenty: TArray<TValue>;
      out Wynik: TValue);
  end;

constructor TWirtualnyInterfejsRaportujący.Create(PIID: PTypeInfo);
begin
  inherited Create(PIID, WywołajMetodę);
end;

procedure TWirtualnyInterfejsRaportujący.WywołajMetodę(Metoda: TRttiMethod;
  const Argumenty: TArray<TValue>; out Wynik: TValue);
var
  Argument: TValue;
  TypArgumentu, NazwaArgumentu: string;
  TymczTyp: TTypeKind;
begin
  Write('Wywołałeś metodę ', Metoda.Name);
  if Length(Argumenty) > 1 then
  begin
    WriteLn(', która ma ', Length(Argumenty) - 1,' parameterów:');
    for Argument in Argumenty do
    begin
      TymczTyp := Argument.Kind;
      if TymczTyp <> tkInterface then
      begin
        NazwaArgumentu := Argument.ToString;
        TypArgumentu := Argument.TypeInfo.Name;
        WriteLn(NazwaArgumentu, ' typu ', TypArgumentu);
      end;
    end;
  end else
  begin
    WriteLn(', która nie ma parametrów.');
  end;
end;

type
  IStartStop = interface(IInvokable)
    ['{3B2171B0-D1C3-4A8C-B09E-ACAC4D625E57}']
    procedure Start;
    procedure Stop(aLiczba: integer);
  end;

var
  StartStop: IStartStop;
begin
  StartStop := TWirtualnyInterfejsRaportujący.Create(TypeInfo(IStartStop)) as IStartStop;
  StartStop.Start;
  StartStop.Stop(42);
  ReadLn;
end.